<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @filesource
*/ /** */

require_once('Mail/RFC822.php');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Mailformat {

///Note to developers -- Do not add new methods to this library.  Methods having to do with formatting message data should go on the Message model (or, if they're more general than just our messages, add them to an appropriate helper).  Methods relating to folders should go on the folder model or the mailbox model as appropriate.  If you need to add a new method and are not sure of an appropriate place for it, talk to Margaret or Adam.  -- MG 2014-11-17


	protected $CI;
	private $is_multiple_folder_search;
	public function __construct(){
		$this->CI =& get_instance();
	}
	
	//deprecated.  Use Folder::find() instead.
	public function get_folder_list() {
		$group_mailboxes = $this->CI->session->userdata('group_mailboxes');
		$mailbox_group = $this->CI->session->userdata('mailbox_group');
		if($mailbox_group !== $this->CI->session->userdata('username')) {
			$valid_mailbox = FALSE;
			foreach($group_mailboxes as $key => $group) {
				if($mailbox_group === $key) { $valid_mailbox = TRUE; }
			}
			//if not a valid mailbox, force it back to the personal mailbox
			if(!$valid_mailbox) { $this->CI->session->set_userdata('mailbox_group',$this->session->userdata('username')); }
		}
		$resource = '/direct/folders/mailbox/'.$this->CI->session->userdata('mailbox_group');
		$resource .= '/format/json';
		return $this->CI->api_model->webservice_call($resource,'GET');
	}
	
//CODE REVIEW NOTES - This is not an appropriate location for this logic.  This should be integrated into the Folder model.  If this is data that we need for every folder, it's probably best to just to generate this information when we run Folder::find() and add it to the results.  If it's information we only need occasionally, this should be refactored to be an instance method on the model.  -- MG 2014-11-17
	//get custom folders for family tree drop down in Create Folder and Change Parent window
	public function get_custom_folder_data($encoded_folder_name) {
		$tree_level = 1;
		$deepest_tree_level = 1;
		$folder_tree_array = array();
		//determine the mailbox
		if(isset($this->CI->mailbox))
			$mailbox = $this->CI->mailbox;
		else
			$mailbox = Mailbox::find_one( array('user_name' => $this->CI->session->userdata('mailbox_group')));
	
		if(!Mailbox::is_an_entity($mailbox)) return false;
	
		//grab the folders for this mailbox
		$folders = $mailbox->folders;
		$subtree_root_folder_name = base64_decode(urldecode($encoded_folder_name));
		foreach($folders as $folder_id => $folder) {
			if($folder->is_custom_folder() && $folder->property_is_empty('parent_id')){
				$this->get_folder_tree_array($folder_id, $folders, $folder_tree_array, '', $tree_level, $subtree_root_folder_name);
				if($tree_level > $deepest_tree_level) {
					$deepest_tree_level = $tree_level;
				}
				$tree_level = 1;
			}
		}
		$custom_folder_data['folder_tree_array'] = $folder_tree_array;
		$custom_folder_data['deepest_tree_level'] = $deepest_tree_level;
		return $custom_folder_data;
	}

//CODE REVIEW NOTES - This is not an appropriate location for this logic.  This should be refactored to be integrated into the Folder model.  --MG 2014/11/17
	protected function get_folder_tree_array($folder_id, $folders, &$custom_folders, $hierarchy, &$tree_level, $subtree_root_folder_name) {
		$folder = $folders[$folder_id];
		//this if statement is to exclude the selected folder itself and its descendants for change parent drop down
		if(CUSTOM_MAILBOX_PREFIX . $subtree_root_folder_name !=  $folder->name) {
			$custom_folders[$folder_id] = array('name_with_hierarchy'=>$hierarchy . ' ' . $folder->name_for_display(), 'name'=>$folder->name_for_display(), 'tree_level'=>$tree_level);
			$child_folders = $folder->child_folders;
			if(!empty($child_folders)) {
				$tree_level++;
				foreach($child_folders as $child) {
					//parent name for the next level child folders
					//$this->get_folder_tree_array($child['id'], $folders, $custom_folders, $hierarchy . '[' . $folder->name_for_display() . ']', $tree_level, $subtree_root_folder_name);
					$this->get_folder_tree_array($child['id'], $folders, $custom_folders, $hierarchy . '&nbsp;&nbsp;&nbsp;&nbsp;', $tree_level, $subtree_root_folder_name);
				}
				$tree_level--;
			}
		}
	}
	
//CODE REVIEW NOTES: By the time you have this much markup in a method, it's time to separate it out into a view.  For a small, contained snippet of markup like this that may be used multiple times on a page, put an underscore at the start of the view name to indicate to other developers that it's not a view for a full page.  When you call it, use the optional third parameter for loading a view that returns the markup as a string for better portability. --MG 2014/11/17
	public function mailbox_list($is_multiple_folder_search = FALSE) {
		$this->is_multiple_folder_search = $is_multiple_folder_search;
		//determine the mailbox
		if(isset($this->CI->mailbox))
			$mailbox = $this->CI->mailbox;
		else
			$mailbox = Mailbox::find_one( array('user_name' => $this->CI->session->userdata('mailbox_group')));
	
		if(!Mailbox::is_an_entity($mailbox)) return false;
	
		//grab the folders for this mailbox
		$folders = $mailbox->folders;
	
		$folder_list = '<ul id="mailbox_list">';
		//display group name at top of mailbox list if relevant
		if($mailbox->is_group) {
			$folder_list .= '<li class="nohover" title="'.$this->CI->session->userdata('mailbox_group_cn').'"><div style="text-overflow: ellipsis; overflow: hidden; white-space: nowrap;">' .
					$this->CI->session->userdata('mailbox_group_cn') . '</div></li>';
		}
		
		$folder_number = count($folders);
		$counter = 0;
		$tree_level = $deepest_tree_level = $family_deepest_tree_level = 1;
		$family_deepest_tree_level_array= array();
		
		$folder_search_select_menu = '<select id="folder_search_select" name="folder_search_select[]" class="" multiple style="height:250px; width:200px;">' .
		'<option value="inbox">Inbox</option><option value="sent">Sent</option><option value="draft">Drafts</option><option value="archived">Archive</option>';
		
		$first_custom_folder_processed = false;

		//get ancestor ids of current folder to expand folder list
		$ancestor_ids = $this->get_ancestor_ids($this->CI->session->mailbox_location(), $folders);
		foreach($folders as $folder_id => $folder) {
			$counter++;
			
			$show_unseen = '';
			if($folder_id == 'draft' && !$folder->property_is_empty('total')) { //for drafts
				$show_unseen = ' ('.$folder->total.')';
			}elseif(!$folder->property_is_empty('new')) {
				$show_unseen = ' ('.$folder->new.')';
			}
			//create mailbox list components
			if($folder->is_custom_folder()){
				if($menu_class == 'system-folder') {
					$menu_class = 'custom-folder';
						
					$folder_list .= '<li class="nohover"><span style="display:block; width:140px; margin-top:5px; height:1px; border-bottom:1px dotted #999;"></span></li>';
					$folder_list .= '<li class="system-folder"><img src="/images/yellow_folder_add.png" alt="Create Folder Icon"/><a class="mbox" onclick="createFolder();" href="#" title="Create Folder">Create Folder</a></li>';
					$add_create_folder = TRUE; //keep track of the fact we have create folder menu added
					$folder_list .= '<div id="custom_folder_tree" class="custom_folder_tree">';
				}
				if(!$first_custom_folder_processed && empty($folder->parent_id)) {
					$menu_class = 'first-custom-folder';
					$first_custom_folder_processed = true;
				}
				else { $menu_class = 'custom-folder'; }

				if($folder->property_is_empty('parent_id')) {
					$folder_tree_data = $this->get_folder_tree_data($folder_id, $folders, $menu_class, '', $tree_level, $deepest_tree_level, $family_deepest_tree_level, $ancestor_ids, $folder_search_select_menu);
					$folder_list .= $folder_tree_data['html'];
					//$family_deepest_tree_level_array[] = $family_deepest_tree_level;
					$family_deepest_tree_level_str = strval($family_deepest_tree_level);
					$folder_list = str_replace('family_deepest_tree_level', $family_deepest_tree_level_str, $folder_list);
					$tree_level = 1;
					$family_deepest_tree_level = 1;
				}
				if(($counter == $folder_number)) {
					$folder_list .= '</div>';
				}
			}
			else {
				//if system folder, don't set custom folder menus
				$menu_class = 'system-folder';
				$menu = $accessibility_menu  = '';
				$folder_image = 'closed_folder_yellow_icon.png';
				//if there is a current mailbox stored in session
				$anchor_class = 'mbox';
				if($folder_id == $this->CI->session->mailbox_location()) {
					//if this mailbox is the current mailbox, make it bold (if not, do not)
					if(!$this->is_multiple_folder_search) {
						$anchor_class = 'cur_mbox';
					}
					$_SESSION['unseen'] = $folder->new;
					$_SESSION['folder_name'] = $folder->name_for_display();
				}
	
				$folder_list .= '<li class="' . $menu_class .'" data-folder-id="'.$folder_id.'">' .
						'<img style="width: 15px; height: 15px;" src="/images/' . $folder_image . '" alt="Folder Icon" />' .
						$menu .'<a title="'.$folder->name_for_display().$show_unseen.'" class="' . $anchor_class . '" href="' . base_url() . 'inbox/change_mailbox/' .
						rawurlencode(base64_encode($folder_id)) . '">' . $folder->name_for_display() . $show_unseen . '</a>';
				$folder_list .= '</li>';
				if(!empty($accessibility_menu)) {
					$folder_list .= '<li id="accessible-menu_' . $folder_id . '" class="custom-mailbox-accessible-menu">'. $accessibility_menu .'</li>';
				}
			}
		}
		$folder_search_select_menu .= '</select>';
		if(!string_contains('createFolder', $folder_list)) {
			$folder_list .= '<li class="nohover"><span style="display:block; width:140px; margin-top:5px; height:1px; border-bottom:1px dotted #999;"></span></li>';
			$folder_list .= '<li class="system-folder"><img src="/images/yellow_folder_add.png" alt="Create Folder Icon"/><a class="mbox" onclick= "createFolder();" href="#" title="Create Folder">Create Folder</a></li>';
			$add_create_folder = TRUE;
		}
		
		$folder_list .= '</ul>';
		$folder_list .= '<input id="nested_folder_max_depth" type="hidden" value="'.NESTED_FOLDER_MAX_DEPTH.'"/>';
		$folder_list .= '<input id="deepest_tree_level" type="hidden" value="'.($deepest_tree_level + 1).'"/>';

		return array('folder_list' => $folder_list, 
				'folders' => $folders,
				'deepest_tree_level' => $deepest_tree_level + 1,
				'folder_search_select_menu' => $folder_search_select_menu);
	
	}
	

	private function get_ancestor_ids($folder_id, $folders, $ancestor_ids = array()) {
		if(isset($folder[$folder_id])) { 
			$folder = $folders[$folder_id];
			if(!empty($folder->parent_id) && $folder->parent_id != 0) {
				array_push($ancestor_ids, $folder->parent_id);
				$ancestor_ids = $this->get_ancestor_ids($folder->parent_id, $folders, $ancestor_ids);
			}
		}
		return $ancestor_ids;
	}
	
	//CODE REVIEW NOTES: By the time you have this much markup in a method, it's time to separate it out into a view.  For a small, contained snippet of markup like this that may be used multiple times on a page, put an underscore at the start of the view name to indicate to other developers that it's not a view for a full page.  When you call it, use the optional third parameter for loading a view that returns the markup as a string for better portability. --MG 2014/11/17
	protected function get_folder_tree_data($folder_id, $folders, &$menu_class, $parent_folder_id, &$tree_level, &$deepest_tree_level, &$family_deepest_tree_level, $cur_folder_ancestor_ids, &$folder_search_select_menu) {
		$folder = $folders[$folder_id];
		$show_unseen = '';
		if($folder_id == 'draft' && !$folder->property_is_empty('total')) { //for drafts
			$show_unseen = ' ('.$folder->total.')';
		}elseif(!$folder->property_is_empty('new')) {
			$show_unseen = ' ('.$folder->new.')';
		}
		$indentation = $this->get_tree_level_indentation($tree_level);
		$folder_search_select_menu .= '<option value="' . $folder_id . '_' . $folder->name_for_display() . '">' . $indentation . $folder->name_for_display() . '</option>';
		//set custom folder menus
		$folder_hash = hash('sha256', $folder->name_for_display());
		$menu = '<span id="' . $folder_hash . '" value="' . $tree_level . '" class="menu">&#9660;</span>';
		$menu .= '<span id="input_span_' . $folder_id . '" class="custom_folder_name" style="display: none;">' . $folder->name_for_display() . '</span>';
		$accessibility_menu = 	'<a id="archive_folder_'.$folder_hash.'" class="hidden_context" href="/inbox/archive_folder/'.rawurlencode(base64_encode($folder->name_for_display())).'">Archive Folder: '.$folder->name_for_display().'</a>'.
				'<a id="change_parent_folder_'.$folder_hash.'" onclick="changeParent(\''.rawurlencode(base64_encode($folder->name_for_display())).'\',$(this).parent().parent().attr(\'id\'),\''.$tree_level.'\',\''.(!$folder->property_is_empty('parent_id') ? $folders[$folder->parent_id]->name_for_display() : '').'\');" class="hidden_context" href="#">Change Parent Folder: '.$folder->name_for_display().'</a>'.
				form_hidden('old_value_'.$folder_hash, $folder->name_for_display(), 'old_value_'.$folder_hash).
				'<label id="rename_folder_label_'.$folder_hash.'" for="rename_folder_'.$folder_hash.'" class="hidden_context">Rename Folder</label>'.
				'<input class="hidden_context" name="rename_folder_'.$folder_hash.'" id="rename_folder_'.$folder_hash.'" type="button" value="Rename Folder" onclick="'.
				'$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'.custom_folder_name\').css(\'display\',\'inline\');'.
				'$(\'[id=&quot;anchor_'.$folder_id.'&quot;]\').css(\'display\',\'none\');'.
				'$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'.custom_folder_name\').editable(\'/inbox/rename_folder/'.
				rawurlencode(base64_encode($folder->name_for_display())).'/\',{ event : \'rename_event\',height: 12,width: 100,style : \'position: relative; float: right; z-index: 100;\', submitdata: {\''.$this->CI->security->get_csrf_token_name().'\': $(\'input[type=&quot;hidden&quot;].token\').val()}, onblur : \'submit\',indicator : \'Saving...\' ,callback: function(value, settings) { $(this).unbind(settings.event);}});'.
				'$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'.custom_folder_name\').trigger(\'rename_event\');"/>';
			
		//if there is a current mailbox stored in session
		$anchor_class = 'mbox';
		if($folder_id == $this->CI->session->mailbox_location()) {
			//if this mailbox is the current mailbox, make it bold (if not, do not)
			if(!$this->is_multiple_folder_search) {
				$anchor_class = 'cur_mbox';
			}
			$_SESSION['unseen'] = $folder->new;
			$_SESSION['folder_name'] = $folder->name_for_display();
		}
	
		$toggle_image = '';
		$child_folders = $folder->child_folders;
		//for nested folder structure js manipulation with disclosing true folder id
		
		if(!empty($child_folders)) {
			$toggle_image = '<a href="#" style="display: inline-block; float: left;" onclick="(event.preventDefault) ? event.preventDefault() : event.returnValue = false; toggleFolderTree($(this).children(\':first\'));"><img id="toggle_image_' . $folder_id . '" src="/images/caret-'.((in_array($folder_id, $cur_folder_ancestor_ids))?'bottom':'right').'.png" alt="Expand Tree Icon"/></a>';
		}
		
		if(isset($tree_level)) { 
			//have to remove any previously set folder depth in the class, since this is called recursively
			//and we only want the one from the last recursive call TODO: refactor this whole library into something more sane
			$menu_class = preg_replace('/ folder-depth[0-9]/', '', $menu_class);
			$menu_class .= ' folder-depth'.$tree_level; 
		}
		
		$folder_list = '<li class="' . $menu_class .'" '.(!empty($parent_folder_id) ? ('name="' . $parent_folder_id .'" ') : ''). 'id="folder_' . $folder_id. '" data-folder-id="'.$folder_id.'">' .
						$toggle_image .
						'<img style="width: 15px; height:15px;" src="/images/closed_folder_yellow_icon.png" alt="Folder Icon" />' .
						$menu .
						'<a id="anchor_' . $folder_id . '" title="'.$folder->name_for_display().$show_unseen.'" class="' . $anchor_class . '" href="' . base_url() . 'inbox/change_mailbox/' .
						rawurlencode(base64_encode($folder_id)) . '">' . $folder->name_for_display() . $show_unseen . '</a>';
		
		if(!empty($accessibility_menu)){ 
			$folder_list .= '<li id="accessible-menu_' . $folder_id . '" class="custom-mailbox-accessible-menu">'. $accessibility_menu .'</li>'; 
		}	
		
		if(count($child_folders) == 0) {
			$folder_list .= '<ul id="ul_' . $folder_id . '" style="display:none;"></ul>';
		}else{
			$tree_level++;
			$menu_class = 'custom-folder';
			if(in_array($folder_id, $cur_folder_ancestor_ids)) { 
				$folder_list .= '<ul id="ul_' . $folder_id . '">';
			}
			else {
				$folder_list .= '<ul id="ul_' . $folder_id . '" style="display:none;">';
			}
			foreach($child_folders as $child) {
				$parent_folder_id = $folder_id;
				$folder_tree_data = $this->get_folder_tree_data($child['id'], $folders, $menu_class, $parent_folder_id, $tree_level, $deepest_tree_level, $family_deepest_tree_level, $cur_folder_ancestor_ids, $folder_search_select_menu);
				$folder_list .= $folder_tree_data['html'];
			}
			$tree_level--;
			$folder_list .= '</ul>';		
		}
		
		$folder_list .= '</li>';
		
		if($tree_level > $deepest_tree_level) {
			$deepest_tree_level = $tree_level;
		}
		
		if($tree_level > $family_deepest_tree_level) {
			$family_deepest_tree_level = $tree_level;
		}
		
		return array('html' => $folder_list);
	}
	
	/* Function designed to strip out repetitive RE's and FWD's from a message subject. Will also replace the most recent RE or FWD
     * with FWD or RE (respectively) if necessary; e.g., forwarding the following message 
	 * RE: Some Subject Here 
	 * ...will instead result in
	 * FWD: Some Subject Here
	*/
	public function msg_subject_sanitize($msg_subject,$type){
		$new_subject = $msg_subject;
		//detect if this is the subject that is already a reply or forward
		$multiple_replies = 	(substr($msg_subject,0,3) == 'RE:') || (substr($msg_subject,0,3) == 'Re:') || 
								(substr($msg_subject,0,2) == 'Fw') || (substr($msg_subject,0,2) == 'FW');
								
		//Conditional offset to handle if there is a Re:/Fwd: of some sort already in the subject
		$offset=((substr($msg_subject,0,4) == 'FWD:') || (substr($msg_subject,0,4) == 'Fwd:')) ? 4 : ($multiple_replies? 3: 0);
		
		//remove previous Re: / Fwd: then add ours
		if($type == 'reply' || $type == 'replyall') { $new_subject = 'Re: '. trim(substr($msg_subject,$offset)); }
		else if($type == 'forward') { $new_subject = 'Fwd: ' . trim(substr($msg_subject,$offset)); }
		else { return $msg_subject; } //just return original subject if not a reply or forward
		
		return $new_subject;
	}
	
	public function display_address_for_send($address){
		if(!is_string($address)) return $this->error->should_be_a_string($address);
		if(empty($address)) return '';
		
		if(string_begins_with('(', $address))
			$address = "\"" . str_replace(" (","\" <",$address); 
		else 
			$address = str_replace("(","<",$address); 
		
		return str_replace(")",">",$address);
	}
	
	public function format_display_addresses_for_sending($addresses) {
		return array_map( array($this, 'display_address_for_send'), $addresses);
	}
	
	public function format_address_list_for_display($addresses) {
		if(!is_null($addresses) && !is_string($addresses)) return $this->CI->error->should_be_a_string($addresses);
		if(empty(trim($addresses))) return array();
				
		$formatted_addresses = array();
		foreach(Mail_RFC822::parseAddressList($addresses) as $address) {
			if(!empty($address->host) && $address->host == "MISSING_DOMAIN") unset($address->host);
			
			if(!empty($address->personal) && !empty($address->mailbox) && !empty($address->host)){ 
				$formatted_addresses[] = $address->personal . " (" . $address->mailbox . "@" . $address->host . ")";
			}elseif(!empty($address->mailbox) && !empty($address->host)){
				$formatted_addresses[] = $address->mailbox . "@" . $address->host;
			}elseif(!empty($address->personal)){ 
				return array($address->personal); 
			}elseif(!empty($address->mailbox)){
				return array($address->mailbox); 
			}elseif(!empty($address->host)){
				return array($address->host); 
			}
		}
		return $formatted_addresses;
	}
	
	public function get_tree_level_indentation($tree_level) {
		$indentation = '';
		for($i = 1; $i < $tree_level; $i++) {
			$indentation .= '&nbsp;&nbsp;&nbsp;';
		}
		return $indentation;
	}
}
?>